/******************************************************************************
#ifdef PADN_DOC
 * %Id: tsd_bridge_if.h,v 1.1 2013/01/23 01:15:09 tanke Exp $
#endif
 *
 * FileName		:tsd_bridge_if.h
 *
 * Description	:I/F definition header for bridge (wrapper)
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef TSD_BRIDGE_IF_H
#define TSD_BRIDGE_IF_H


#define TSD_IOC_QUERYRESOURCE	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 1 , sizeof(struct tsd_query_resource_arg_t))
#define TSD_IOC_STARTTSINPUT	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 2 , sizeof(struct tsd_input_arg_t))
#define TSD_IOC_STOPTSINPUT		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 3 , sizeof(struct tsd_input_arg_t))
#define TSD_IOC_ALLOCPIDVIDEO	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 4 , sizeof(struct tsd_alloc_pid_arg_t))
#define TSD_IOC_FREEPIDVIDEO	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 5 , sizeof(struct tsd_entry_arg_t))
#define TSD_IOC_STARTVIDEO		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 6 , sizeof(struct tsd_entry_arg_t))
#define TSD_IOC_STOPVIDEO		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 7 , sizeof(struct tsd_entry_arg_t))
#define TSD_IOC_ALLOCPIDAUDIO	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 8 , sizeof(struct tsd_alloc_pid_arg_t))
#define TSD_IOC_FREEPIDAUDIO	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 9 , sizeof(struct tsd_entry_arg_t))
#define TSD_IOC_STARTAUDIO		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 10 , sizeof(struct tsd_entry_arg_t))
#define TSD_IOC_STOPAUDIO		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 11 , sizeof(struct tsd_entry_arg_t))
#define TSD_IOC_ALLOCPIDPCR		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 12 , sizeof(struct tsd_alloc_pid_arg_t))
#define TSD_IOC_FREEPIDPCR		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 13 , sizeof(struct tsd_entry_arg_t))
#define TSD_IOC_REQUESTPCR		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 14 , sizeof(struct tsd_entry_arg_t))
#define TSD_IOC_CANCELPCR		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 15 , sizeof(struct tsd_entry_arg_t))
#define TSD_IOC_GETSTC			IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 16 , sizeof(struct tsd_get_stc_arg_t))
#define TSD_IOC_SETSTCFREQ		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 17, sizeof(struct tsd_stc_freq_arg_t))
#define TSD_IOC_GETSTCFREQ		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 18 , sizeof(struct tsd_stc_freq_arg_t))
#define TSD_IOC_ALLOCPIDSEC		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 19 , sizeof(struct tsd_alloc_pid_arg_t))
#define TSD_IOC_FREEPIDSEC		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 20 , sizeof(struct tsd_entry_arg_t))
#define TSD_IOC_REQUESTSEC		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 21 , sizeof(struct tsd_request_sec_arg_t))
#define TSD_IOC_CANCELSEC		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 22 , sizeof(struct tsd_reqid_arg_t))
#define TSD_IOC_UPDATESEC		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 23 , sizeof(struct tsd_update_sec_arg_t))
#define TSD_IOC_ALLOCPIDPESP	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 24 , sizeof(struct tsd_alloc_pid_arg_t))
#define TSD_IOC_FREEPIDPESP		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 25 , sizeof(struct tsd_entry_arg_t))
#define TSD_IOC_REQUESTPESP		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 26 , sizeof(struct tsd_request_pesp_arg_t))
#define TSD_IOC_CANCELPESP		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 27 , sizeof(struct tsd_reqid_arg_t))
#define TSD_IOC_UPDATEPESP		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 28 , sizeof(struct tsd_update_pesp_arg_t))
#define TSD_IOC_INITDESC		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 29 , sizeof(struct tsd_init_desc_arg_t))
#define TSD_IOC_ALLOCDESC		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 30 , sizeof(struct tsd_alloc_desc_arg_t))
#define TSD_IOC_FREEDESC		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 31 , sizeof(struct tsd_entry_arg_t))
#define TSD_IOC_CHANGEDESCKEY	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 33 , sizeof(struct tsd_change_desc_key_arg_t))
#define TSD_IOC_STARTPIDDESC	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 34 , sizeof(struct tsd_desc_pid_arg_t))
#define TSD_IOC_STOPPIDDESC		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 35 , sizeof(struct tsd_desc_pid_arg_t))
#define TSD_IOC_GETSCRAMBLESTATUS	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 36, sizeof(struct tsd_get_scramble_status_arg_t))
#define TSD_IOC_STARTTSOUTPUT	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 37 , sizeof(struct tsd_start_tsoutput_arg_t))
#define TSD_IOC_STOPTSOUTPUT	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 38 , sizeof(struct tsd_stop_tsoutput_arg_t))
#define TSD_IOC_ALLOCPIDTSOUTPUT	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 39 , sizeof(struct tsd_alloc_pid_arg_t))
#define TSD_IOC_FREEPIDTSOUTPUT	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 40 , sizeof(struct tsd_entry_arg_t))
#define TSD_IOC_STARTPIDTSOUTPUT	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 42 , sizeof(struct tsd_entry_arg_t))
#define TSD_IOC_STOPPIDTSOUTPUT	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 43 , sizeof(struct tsd_entry_arg_t))
#define TSD_IOC_SETPATTSOUTPUT	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 44 , sizeof(struct tsd_setpat_arg_t))
#define TSD_IOC_STARTPATTSOUTPUT	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 45 , sizeof(struct tsd_start_si_tsoutput_arg_t))
#define TSD_IOC_STOPPATTSOUTPUT	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 46 , sizeof(struct tsd_stop_tsoutput_arg_t))
#define TSD_IOC_SETPMTTSOUTPUT	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 47 , sizeof(struct tsd_setpmt_arg_t))
#define TSD_IOC_STARTPMTTSOUTPUT	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 48 , sizeof(struct tsd_start_si_tsoutput_arg_t))
#define TSD_IOC_STOPPMTTSOUTPUT	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 49 , sizeof(struct tsd_stop_tsoutput_arg_t))
#define TSD_IOC_SETSITTSOUTPUT	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 50 , sizeof(struct tsd_setsit_arg_t))
#define TSD_IOC_STARTSITTSOUTPUT	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 51 , sizeof(struct tsd_start_si_tsoutput_arg_t))
#define TSD_IOC_STOPSITTSOUTPUT	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 52 , sizeof(struct tsd_stop_tsoutput_arg_t))
#define TSD_IOC_INSERTDITTSOUTPUT	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 53 , sizeof(struct tsd_insert_dit_arg_t))
#define TSD_IOC_REQUESTTSINPUTSTATUS	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 54 , sizeof(struct tsd_request_tsi_status_arg_t))
#define TSD_IOC_CANCELTSINPUTSTATUS	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 55 , sizeof(struct tsd_reqid_arg_t))
#define TSD_IOC_REQUESTPIDSTATUS	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 56 , sizeof(struct tsd_request_pid_status_arg_t))
#define TSD_IOC_CANCELPIDSTATUS	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 57 , sizeof(struct tsd_reqid_arg_t))
/* msl only */
#define TSD_IOC_INITTSINPUT				IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 66 , sizeof(struct tsd_init_tsinput_t))
#define TSD_IOC_STARTAVOUTPUT			IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 76 , sizeof(struct tsd_start_avoutput_arg_t))
#define TSD_IOC_STOPAVOUTPUT			IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 77 , sizeof(struct tsd_stop_avoutput_arg_t))

#define TSD_IOC_REQUESTTSOUTPUTSTATUS	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 86 , sizeof(struct tsd_request_tso_status_arg_t))
#define TSD_IOC_CANCELTSOUTPUTSTATUS	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 87 , sizeof(struct tsd_reqid_arg_t))
#define TSD_IOC_REQUESTAVOUTPUTSTATUS	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 88 , sizeof(struct tsd_request_avo_status_arg_t))
#define TSD_IOC_CANCELAVOUTPUTSTATUS	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 89 , sizeof(struct tsd_reqid_arg_t))
#define TSD_IOC_RESETPKTCNT             IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 90 , sizeof(struct tsd_reset_pktcnt_arg_t))
#define TSD_IOC_STARTPKTCNT             IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 91 , sizeof(struct tsd_pktcnt_arg_t))
#define TSD_IOC_STOPPKTCNT              IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 92 , sizeof(struct tsd_pktcnt_arg_t))
#define TSD_IOC_GETPKTCNT               IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 93 , sizeof(struct tsd_get_pktcnt_arg_t))
#define TSD_IOC_REQUESTSIOVERWRITEPKTCNT IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 94 , sizeof(struct tsd_reqsi_overwrite_pktcnt_arg_t))
#define TSD_IOC_CANCELSIOVERWRITEPKTCNT  IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 95 , sizeof(struct tsd_can_pktcnt_arg_t))
#define TSD_IOC_REQUESTSECACQUISITIONPKTCNT IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 96 , sizeof(struct tsd_req_pktcnt_arg_t))
#define TSD_IOC_CANCELSECACQUISITIONPKTCNT  IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 97 , sizeof(struct tsd_can_pktcnt_arg_t))
#define TSD_IOC_REQUESTPCRDISCONPKTCNT      IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 98 , sizeof(struct tsd_reqpcr_discon_pktcnt_arg_t))
#define TSD_IOC_CANCELPCRDISCONPKTCNT       IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 99 , sizeof(struct tsd_canpcr_discon_pktcnt_arg_t))
#define TSD_IOC_SETPCRTHRESHOLDPKTCNT       IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 100 , sizeof(struct tsd_set_pcr_threshold_pktcnt_arg_t))
#define TSD_IOC_ALLOCATEPIDHEDDET           IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 107 , sizeof(struct tsd_allocate_pid_heddet_arg_t))
#define TSD_IOC_FREEPIDHEDDET               IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 108 , sizeof(struct tsd_heddet_arg_t))
#define TSD_IOC_REQUESTHEDDET               IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 110 , sizeof(struct tsd_heddet_arg_t))
#define TSD_IOC_CANCELHEDDET                IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 111 , sizeof(struct tsd_heddet_arg_t))

#define TSD_IOC_INIT						IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 112 , sizeof(struct tsd_void_arg_t))
#define TSD_IOC_TERM						IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 113 , sizeof(struct tsd_void_arg_t))
#define TSD_IOC_CHANGESTCRECOVERY			IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 114 , sizeof(struct tsd_change_stc_recovery_arg_t))
#define TSD_IOC_STARTCCIGNORE	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 120 , sizeof(struct tsd_start_cc_ignore_arg_t))

/* for callback */
#define TSD_IOC_SECNOTIFY(size)		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 1 , size)
#define TSD_IOC_PESNOTIFY(size)		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 2 , size)

#define TSD_IOC_TSINOTIFY		IOSC_DEFINE_WRITECMD(L_TSD_MAGIC, 3 , sizeof(struct tsd_status_notify_arg_t))
#define TSD_IOC_TSONOTIFY		IOSC_DEFINE_WRITECMD(L_TSD_MAGIC, 4 , sizeof(struct tsd_status_notify_arg_t))
#define TSD_IOC_AVONOTIFY		IOSC_DEFINE_WRITECMD(L_TSD_MAGIC, 5 , sizeof(struct tsd_status_notify_arg_t))
#define TSD_IOC_PIDNOTIFY		IOSC_DEFINE_WRITECMD(L_TSD_MAGIC, 6 , sizeof(struct tsd_pid_status_notify_arg_t))

#define TSD_IOC_STCNOTIFY		IOSC_DEFINE_WRITECMD(L_TSD_MAGIC, 8 , sizeof(struct tsd_stc_notify_arg_t))
#define TSD_IOC_MEMTERMFUNC		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 9 , sizeof(struct tsd_mem_term_func_arg_t))
#define TSD_IOC_MEMALLOCATEFUNC	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 10 , sizeof(struct tsd_mem_allocate_func_arg_t))
#define TSD_IOC_MEMFREEFUNC		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 11 , sizeof(struct tsd_mem_free_func_arg_t))
#define TSD_IOC_SIOVERWRITEPKTCNTNOTIFY		IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 14 , sizeof(struct tsd_pktcnt_notify_arg_t))
#define TSD_IOC_SECACQUISITIONPKTCNTNOTIFY	IOSC_DEFINE_RWCMD(L_TSD_MAGIC, 15 , sizeof(struct tsd_pktcnt_notify_arg_t))
#define TSD_IOC_PCRDISCONPKTCNTNOTIFY		IOSC_DEFINE_WRITECMD(L_TSD_MAGIC, 16 , sizeof(struct tsd_pktcnt_notify_arg_t))
#define TSD_IOC_DUMMYPKTCNTNOTIFY		IOSC_DEFINE_WRITECMD(L_TSD_MAGIC, 17 , sizeof(struct tsd_pktcnt_notify_arg_t))
#define TSD_IOC_HEDDETNOTIFY		IOSC_DEFINE_WRITECMD(L_TSD_MAGIC, 18 , sizeof(struct tsd_heddet_notify_arg_t))
#define TSD_IOC_SIOVWPATNOTIFY		IOSC_DEFINE_WRITECMD(L_TSD_MAGIC, 20 , sizeof(struct tsd_si_overwrite_notify_arg_t))
#define TSD_IOC_SIOVWPMTNOTIFY		IOSC_DEFINE_WRITECMD(L_TSD_MAGIC, 21 , sizeof(struct tsd_si_overwrite_notify_arg_t))
#define TSD_IOC_SIOVWSITNOTIFY		IOSC_DEFINE_WRITECMD(L_TSD_MAGIC, 22 , sizeof(struct tsd_si_overwrite_notify_arg_t))
#endif /* TSD_BRIDGE_IF_H */
